﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_Instruments_PainOutcomes_Discharge : BaseTBIInstrumentPage {

    #region Variable Declarations

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();

    protected int _surveyTypeId = 28; // Database Id for Pain Outcomes Questionnaire VA Long Form - Discharge

    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();

    #endregion

    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_Instruments_PainOutcomes_Discharge() {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #region Protected Methods

    /// <summary>
    /// Page Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        TBIServiceTO _tbiServiceTo;

        try {
            _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
            _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;

            string instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            LabelInstrumentTitle.Text = instTitle;
            Page.Title = "TBI Instruments - " + instTitle;

            if (_tbiInstrumentManager.TbiServiceTo != null) {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);

                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        } catch (Exception ex) {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "PainOutcomes_Discharge.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2", false);
        }

        if (!IsPostBack) {
            if (instrumentType.Status != null) {
                _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
            }

            string _snum = "";
            if (_tbiInstrumentManager.TbiServiceTo != null) {
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }

            if (!string.IsNullOrEmpty(_snum))
            {
                string patICN = patientManager.GetPatientICNBySnum(_snum);

                if (!string.IsNullOrEmpty(patICN)) {
                    ViewState["PatientICN"] = patICN;
                    RefreshSurvey(patICN);
                } else {
                    throw new ArgumentException("Patient with this SSN does not exist.");
                }

                if (_survey != null && !_survey.isNew) {
                    SetUpSurvey(_survey);
                    //calculateTotal();
                    HideShowQuestions(_survey);
                }
                string referrer = "";
                if (Request.UrlReferrer != null) {
                    referrer = Request.UrlReferrer.PathAndQuery;
                }
                ViewState["referrer"] = referrer;
            }

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("PainOutcomes_Discharge.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            } else {
                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        }
        QuestionList = GetAllQuestionsForSurvey();

        // Set control values for Diagnosis Question
        ctrlDiagnosis.QuestionText = GetQuestionText("DX");
        ctrlDiagnosis.SurveyTypeCode = HiddenSurveyType.Value;

        //LabelDate1.Text = GetQuestionText("D");
        LabelForQ1.Text = GetQuestionText("1");
        LabelForQ2.Text = GetQuestionText("2");
        LabelForQ3.Text = GetQuestionText("3");
        LabelForQ4.Text = GetQuestionText("4");
        LabelForQ5.Text = GetQuestionText("5");
        LabelForQ6.Text = GetQuestionText("6");
        LabelForQ7.Text = GetQuestionText("7");
        LabelForQ8.Text = GetQuestionText("8");
        LabelForQ9.Text = GetQuestionText("9");
        LabelForQ10.Text = GetQuestionText("10");
        LabelForQ11.Text = GetQuestionText("11");
        LabelForQ12.Text = GetQuestionText("12");
        LabelForQ13.Text = GetQuestionText("13");
        LabelForQ14.Text = GetQuestionText("14");
        LabelForQ15.Text = GetQuestionText("15");
        LabelForQ16.Text = GetQuestionText("16");
        LabelForQ17.Text = GetQuestionText("17");
        LabelForQ18.Text = GetQuestionText("18");
        LabelForQ19.Text = GetQuestionText("19");
        LabelForQ20.Text = GetQuestionText("20");
        LabelForQ21.Text = GetQuestionText("21");
        LabelForQ22.Text = GetQuestionText("22");
        LabelForQ23.Text = GetQuestionText("23");
        LabelForQ24.Text = GetQuestionText("24");
        LabelForQ25.Text = GetQuestionText("25");
        LabelForQ26.Text = GetQuestionText("26");
        LabelForQ27.Text = GetQuestionText("27");
        LabelForQ28.Text = GetQuestionText("28");
        //dpDate1.MaxDate = DateTime.Now;
        dpDateQ1.MaxDate = DateTime.Now;
    }


    private void HideShowQuestions(SURVEY survey) {
        try {
            foreach (var sResult in survey.SURVEY_RESULTs) {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) {
                    case "26":
                        switch (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.ToUpper()) {
                            case "A":
                                plchldrQ27_28.Visible = true;
                                break;
                            case "B":
                                plchldrQ27_28.Visible = false;
                                txtQ27_1.Text = "";
                                txtQ27_2.Text = "";
                                rblQ28.SelectedIndex = -1;
                                break;
                            default:
                                plchldrQ27_28.Visible = true;
                                txtQ27_1.Text = "";
                                txtQ27_2.Text = "";
                                rblQ28.SelectedIndex = -1;
                                break;
                        }
                        break;
                }
            }
        } catch (Exception ex) { }
    }


    protected void rblQ26_SelectedIndexChanged(object sender, EventArgs e) {
        switch (rblQ26.SelectedIndex) {
            case 0:
                plchldrQ27_28.Visible = true;
                break;
            case 1:
                plchldrQ27_28.Visible = false;
                txtQ27_1.Text = "";
                txtQ27_2.Text = "";
                rblQ28.SelectedIndex = -1;
                break;
            default:
                plchldrQ27_28.Visible = false;
                txtQ27_1.Text = "";
                txtQ27_2.Text = "";
                rblQ28.SelectedIndex = -1;
                break;
        }
    }


    protected override void LoadViewState(object savedState) {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState() {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower()) {
                return ques.QUESTION_TEXT;
            }
        }

        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower()) {
                return ques.ID;
            }
        }

        return 0;
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        SetUpSurvey(_survey);
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);

        if (status > 0) {
            Session["survey"] = _survey;
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        } else {
            SetUpSurvey(_survey); //Follow Save Draft logic 
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";

        Page.Validate();

        if (Page.IsValid) {
            SaveCompleteSurvey(ref status);
            //SetUpSurvey(_survey);
            Response.Redirect("PainOutcomes_Discharge.aspx", false);
        } else {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e) {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Hide or Show instructions
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lnkBtnToggleInstructions_OnClick(object sender, EventArgs e) {
        if (PanelInstructions.Visible) {
            PanelInstructions.Visible = false;
            lnkBtnToggleInstructions.Text = "Click for Instructions";
        } else {
            PanelInstructions.Visible = true;
            lnkBtnToggleInstructions.Text = "Hide Instructions";
        }
    }


    #endregion

    #region Private Methods


    /// <summary>
    /// Calculates number of years and months based on number of months
    /// </summary>
    /// <returns></returns>
    private void getYearsMonths(string strMonths, out int years, out int months) {
        int.TryParse(strMonths, out months);
        years = (int)Math.Truncate((double)months / 12);
        months = months - 12 * years;
    }

    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey() {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN) {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

        if (surveys.Count > 0) {
            _survey = surveys.First();
        } else {
            _survey = new SURVEY();
        }

        _survey.SetAsChangeTrackingRoot();
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status) {
        Page.Validate();
        if (Page.IsValid) {
            //if ((Page.IsValid) && IsQRPT1Valid() && Is28ABValid()) {
            string patientICN = String.Empty;

            status = 0;

            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null) {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("PainOutcomes_Discharge.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("PainOutcomes_Discharge.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null) {
                if (_survey.isNew) {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("PainOutcomes_Discharge.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    } else {
                        _survey.SURVEY_STATUS = "inprocess";

                        _survey.SetAsInsertOnSubmit();

                        _survey.patient_ICN = patientICN;

                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);

                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);

                //Fortify errors on this line (this.Master as RegistryInstrumentMaster).SetDirtyFlag(false);
                ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);

                RefreshSurvey(patientICN);
                SuppressSaveMessage = false;
            }
        }
    }



    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey) {
        //calculateTotal(); // call to re-calculate total score.

        // Ensure lblSurveyError does not contain - ERROR
        if (!lblSurveyError.Text.Contains("ERROR")) {
            List<STD_QUESTION> questions = GetAllQuestionsForSurvey();

            //Delete all the survey results from database if there are any.
            SURVEY surveyWithResults = _tbiInstrumentManager.GetSurveyWithAllAnswers(survey.SURVEYS_ID);
            _tbiInstrumentManager.DeleteAllSurveyResults(surveyWithResults);



            // Question DX
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question DX choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ctrlDiagnosis.GetSelectedId());
                _surveyResult.RESULT_TEXT = ctrlDiagnosis.GetSelectedResultText();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question DX");
            }

            // Question D
            //_surveyResult = new SURVEY_RESULT();
            //if (dpDate1.SelectedDate != null) {
            //    STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "D");
            //    _surveyResult = new SURVEY_RESULT();
            //    try {
            //        // Add Question DTE choice
            //        _surveyResult.STD_QUESTION_CHOICE_ID = questionD.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            //        _surveyResult.RESULT_TEXT = ((DateTime)dpDate1.SelectedDate).ToShortDateString();
            //        survey.SURVEY_RESULTs.Add(_surveyResult);
            //    } catch (Exception surveyEx) {
            //        Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question D");
            //    }
            //}

            // Question Q1
            _surveyResult = new SURVEY_RESULT();
            if (dpDateQ1.SelectedDate != null) {
                STD_QUESTION questionQ1 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "1");
                _surveyResult = new SURVEY_RESULT();
                try {
                    _surveyResult.STD_QUESTION_CHOICE_ID = questionQ1.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = ((DateTime)dpDateQ1.SelectedDate).ToShortDateString();
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                } catch (Exception surveyEx) {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 1");
                }
            }

            // Question 2
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "2");
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 2 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ2.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ2.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 2");
            }

            // Question 3
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 3 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ3.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ3.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 3");
            }

            // Question 4
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 4 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ4.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ4.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 4");
            }

            // Question 5
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 5 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ5.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ5.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 5");
            }

            // Question 6
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 6 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ6.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ6.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 6");
            }

            // Question 7
            STD_QUESTION question7 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7");
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 7 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ7.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ7.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 7");
            }

            // Question 8
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 8 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ8.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ8.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 8");
            }

            // Question 9
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 9 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ9.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ9.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 9");
            }

            // Question 10
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 10 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ10.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ10.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 10");
            }

            // Question 11
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 11 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ11.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ11.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 11");
            }

            // Question 12
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 12 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ12.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ12.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 12");
            }

            // Question 13
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 13 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ13.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ13.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 13");
            }

            // Question 14
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 14 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ14.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ14.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 14");
            }

            // Question 15
            STD_QUESTION question15 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "15");
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 15 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ15.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ15.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 15");
            }

            // Question 16
            STD_QUESTION question16 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "16");
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 16 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ16.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ16.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 16");
            }

            // Question 17
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 17 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ17.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ17.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 17");
            }

            // Question 18
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 18 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ18.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ18.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 18");
            }

            // Question 19
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 19 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ19.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ19.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 19");
            }

            // Question 20
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 20 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ20.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ20.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 20");
            }

            // Question 21
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 21 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ21.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ21.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 21");
            }

            // Question 22
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 22 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ22.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ22.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 22");
            }

            // Question 23
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 23 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ23.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ23.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 23");
            }

            // Question 24
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 24 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ24.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ24.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 24");
            }

            // Question 25
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 25 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ25.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ25.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 25");
            }

            // Question 26
            _surveyResult = new SURVEY_RESULT();
            try {
                // Add Question 26 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ26.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ26.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 26");
            }

            // collect Q27 and Q28 only if Q26=="A" (Yes)
            if (rblQ26.SelectedItem.Text.ToUpper() == "YES") {
                // Question 27
                STD_QUESTION question27 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "27");
                _surveyResult = new SURVEY_RESULT();
                try {
                    // Add Question 27 choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = question27.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    int years = 0;
                    int months = 0;
                    int.TryParse(txtQ27_1.Text, out years);
                    int.TryParse(txtQ27_2.Text, out months);
                    months = years * 12 + months;
                    _surveyResult.RESULT_TEXT = months.ToString();
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                } catch (Exception surveyEx) {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 27");
                }

                // Question 28
                _surveyResult = new SURVEY_RESULT();
                try {
                    // Add Question 28 choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ28.SelectedValue);
                    _surveyResult.RESULT_TEXT = rblQ28.SelectedItem.Text;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                } catch (Exception surveyEx) {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Discharge.aspx", "100027", "SaveSurvey() - Question 28");
                }
            }

        } else {
            // do not save ... 
        }
    }// END SaveSurvey




    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey) {
        int months = 0;
        int years = 0;
        try {
            foreach (var sResult in survey.SURVEY_RESULTs) {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) {
                    case "DX":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            ctrlDiagnosis.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                            if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other")) {
                                ctrlDiagnosis.SetOtherDescriptionText(sResult.RESULT_TEXT);
                            }
                        } else {
                            ctrlDiagnosis.SelectedChoiceId = null;
                        }
                        break;
                    //case "D":
                    //    if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                    //        DateTime temp;
                    //        if (DateTime.TryParse(sResult.RESULT_TEXT, out temp)) {
                    //            dpDate1.SelectedDate = temp;
                    //        }
                    //    }
                    //    break;
                    case "1":
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                            DateTime temp;
                            if (DateTime.TryParse(sResult.RESULT_TEXT, out temp)) {
                                dpDateQ1.SelectedDate = temp;
                            }
                        }
                        break;
                    case "2":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ2.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ2.SelectedIndex = -1;
                        }
                        break;
                    case "3":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ3.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ3.SelectedIndex = -1;
                        }
                        break;
                    case "4":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ4.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ4.SelectedIndex = -1;
                        }
                        break;
                    case "5":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ5.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ5.SelectedIndex = -1;
                        }
                        break;
                    case "6":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ6.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ6.SelectedIndex = -1;
                        }
                        break;
                    case "7":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ7.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ7.SelectedIndex = -1;
                        }
                        break;
                    case "8":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ8.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ8.SelectedIndex = -1;
                        }
                        break;
                    case "9":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ9.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ9.SelectedIndex = -1;
                        }
                        break;
                    case "10":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ10.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ10.SelectedIndex = -1;
                        }
                        break;
                    case "11":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ11.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ11.SelectedIndex = -1;
                        }
                        break;
                    case "12":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ12.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ12.SelectedIndex = -1;
                        }
                        break;
                    case "13":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ13.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ13.SelectedIndex = -1;
                        }
                        break;
                    case "14":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ14.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ14.SelectedIndex = -1;
                        }
                        break;
                    case "15":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ15.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ15.SelectedIndex = -1;
                        }
                        break;
                    case "16":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ16.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ16.SelectedIndex = -1;
                        }
                        break;
                    case "17":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ17.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ17.SelectedIndex = -1;
                        }
                        break;
                    case "18":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ18.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ18.SelectedIndex = -1;
                        }
                        break;
                    case "19":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ19.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ19.SelectedIndex = -1;
                        }
                        break;
                    case "20":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ20.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ20.SelectedIndex = -1;
                        }
                        break;
                    case "21":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ21.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ21.SelectedIndex = -1;
                        }
                        break;
                    case "22":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ22.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ22.SelectedIndex = -1;
                        }
                        break;
                    case "23":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ23.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ23.SelectedIndex = -1;
                        }
                        break;
                    case "24":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ24.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ24.SelectedIndex = -1;
                        }
                        break;
                    case "25":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ25.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ25.SelectedIndex = -1;
                        }
                        break;
                    case "26":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ26.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ26.SelectedIndex = -1;
                        }
                        break;
                    case "27":
                        months = 0;
                        years = 0;
                        getYearsMonths(sResult.RESULT_TEXT, out years, out months);
                        txtQ27_1.Text = years.ToString();
                        txtQ27_2.Text = months.ToString();
                        break;
                    case "28":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ28.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ28.SelectedIndex = -1;
                        }
                        break;

                    default:
                        break;
                }
            }
        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "PainOutcomes_Discharge.aspx", "100027", "SetUpSurvey()");
        }
    }
    // END SetUpSurvey

    #endregion
}
